/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.util.RomanNumeral;

public class EMIAnvilRecipeCategory
extends EmiRecipeCategory {
    private final int anvilLevel;
    private final List<class_5481> titleLines;

    public EMIAnvilRecipeCategory(class_2960 id, EmiRenderable icon, int anvilLevel) {
        super(id, icon);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public EMIAnvilRecipeCategory(class_2960 id, EmiRenderable icon, EmiRenderable simplified, int anvilLevel) {
        super(id, icon, simplified);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public EMIAnvilRecipeCategory(class_2960 id, EmiRenderable icon, EmiTexture simplified, Comparator<EmiRecipe> sorter, int anvilLevel) {
        super(id, icon, (EmiRenderable)simplified, sorter);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public void renderSimplified(class_4587 stack, int x, int y, float delta) {
        super.renderSimplified(stack, x, y, delta);
        class_327 font = class_310.method_1551().field_1772;
        String content = RomanNumeral.toRoman(this.anvilLevel);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        int xx = x + 19 - 2 - font.method_1727(content);
        int yy = y + 6 + 3;
        class_1159 matrix = stack.method_23760().method_23761();
        font.method_27521(content, (float)(xx - 1), (float)(yy - 1), -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)xx, (float)(yy - 1), -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)(xx + 1), (float)(yy - 1), -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)(xx - 1), (float)yy, -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)(xx + 1), (float)yy, -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)(xx - 1), (float)(yy + 1), -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)(xx + 1), (float)(yy + 1), -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)xx, (float)(yy + 1), -16777216, false, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        font.method_27521(content, (float)xx, (float)yy, -1, true, matrix, (class_4597)bufferSource, false, 0, 0xF000F0);
        bufferSource.method_22993();
    }

    public List<class_5684> getTooltip() {
        ArrayList list = Lists.newArrayList();
        if (this.titleLines.isEmpty()) {
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)EmiUtil.translateId((String)"emi.category.", (class_2960)this.getId())))));
        } else {
            for (class_5481 line : this.titleLines) {
                list.add(class_5684.method_32662((class_5481)line));
            }
        }
        list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal((String)EmiUtil.getModName((String)this.getId().method_12836()), (class_124[])new class_124[]{class_124.field_1078, class_124.field_1056}))));
        return list;
    }
}

